const express = require('express')
const app = express()
require('dotenv').config();
const mongoose = require('mongoose')
const userRoutes = require('./routes/userRoutes')
const logger = require('./logger');
const port = process.env.PORT || 3000

app.use(express.json());

const MONGO_URI = 'mongodb://localhost:27017/test';

/*
Create a node Express server.
Connect to mongo DB.
Create API to create users, update a user and get list of users.
Add proper logs Write unit tests to test your code.
*/

mongoose.connect(MONGO_URI)
    .then(() => {
      console.log('Connected to MongoDB');
    })
    .catch((error) => {
      console.error('Error connecting to MongoDB:', error);
    });


app.use('/api/users', userRoutes);


app.listen(port ,() => {
    logger.info(`Server listening at http://localhost:${port}`);
  });


  module.exports = app