# Installing Kubernetes on local

## Table of Content

- [Kind](#kind)
- [Install Kind](#install-kind)
- [Creating Cluster](#creating-cluster)
- [Interacting With Your Cluster](#interacting-with-your-cluster)
- [Deleting a cluster](#deleting-a-cluster)
- [Loading an Image Into Your Cluster](#loading-an-image-into-your-cluster)
- [Additional information](#additional-information)
- [Reference](#reference)


## Kind
kind is a tool for running local Kubernetes clusters using Docker container “nodes”.
kind was primarily designed for testing Kubernetes itself, but may be used for local development or CI.


### Install Kind
- Download the binary for kind
```bash
curl -Lo ./kind https://kind.sigs.k8s.io/dl/v0.11.1/kind-linux-amd64
chmod +x ./kind
sudo mv ./kind /usr/local/bin/kind
```
- Verify installation
```bash
kind version
```

### Install kubectl
- Download the binary for kubectl
[Follow the url](https://kubernetes.io/docs/tasks/tools/install-kubectl-linux/#install-using-native-package-management)

### Creating Cluster
Creating a Kubernetes cluster is as simple as `kind create cluster`.  

This will bootstrap a Kubernetes cluster using a pre-built [node image](https://kind.sigs.k8s.io/docs/design/node-image). Prebuilt images are hosted at [kindest/node](https://hub.docker.com/r/kindest/node/), but to find images suitable for a given release currently you should check the [release notes](https://github.com/kubernetes-sigs/kind/releases) for your given kind version (check with kind version) where you'll find a complete listing of images created for a kind release.

To specify another image use the `--image` flag – `kind create cluster --image=....`

### Interacting With Your Cluster
After [creating a cluster](#creating-cluster), you can use [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) to interact with it by using the [configuration file generated by kind](https://kubernetes.io/docs/tasks/access-application-cluster/configure-access-multiple-clusters/).

By default, the cluster access configuration is stored in ${HOME}/.kube/config if $KUBECONFIG environment variable is not set.

If $KUBECONFIG environment variable is set, then it is used as a list of paths (normal path delimiting rules for your system). These paths are merged. When a value is modified, it is modified in the file that defines the stanza. When a value is created, it is created in the first file that exists. If no files in the chain exist, then it creates the last file in the list.

You can use the --kubeconfig flag when creating the cluster, then only that file is loaded. The flag may only be set once and no merging takes place.

To see all the clusters you have created, you can use the get clusters command.

For example, let's say you create two clusters:

```bash
sudo kind create cluster # Default cluster context name is `kind`.
...
sudo kind create cluster --name demo
```

When you list your kind clusters, you will see something like the following:
```bash
sudo kind get clusters
kind
demo
```

In order to interact with a specific cluster, you only need to specify the cluster name as a context in kubectl:
```bash
kubectl cluster-info --context kind-kind
kubectl cluster-info --context kind-demo
```

Note:
To avoid using `--context` for every command you can use following commands:
```bash
kubectl config use-context kind-demo
```

To list all the available cotexts
```bash
kubectl config  get-contexts
```

## Deleting a cluster
If you created a cluster with `kind create cluster` then deleting is equally simple:
```bash
kind delete cluster
```
If the flag `--name` is not specified, kind will use the default cluster context name `kind` and delete that cluster.


## Loading an Image Into Your Cluster
Docker images can be loaded into your cluster nodes with:

`kind load docker-image my-custom-image-0 my-custom-image-1 --name <kind_cluster_name>`


## Additional information
- You can configure kubernetes cluster with multiple worker nodes and master node to simulate any environment.

## Reference
[Kind Quick Start](https://kind.sigs.k8s.io/docs/user/quick-start/#creating-a-cluster)

---
[Home](/README.md) | [Back](../README.md)
